<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Tests of the upgrade to the new Moodle question engine for attempts at
 * multichoice questions.
 *
 * @package    qtype
 * @subpackage multichoice
 * @copyright  2009 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') || die();

global $CFG;
require_once($CFG->dirroot . '/question/engine/upgrade/tests/helper.php');


/**
 * Testing the upgrade of multichoice question attempts.
 *
 * @copyright  2009 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class qtype_multichoice_attempt_upgrader_test extends question_attempt_upgrader_test_base {

    public function test_multichoice_deferredfeedback_history960() {
        $quiz = (object) array(
            'id' => '1',
            'course' => '3',
            'name' => 'Test quiz 1',
            'intro' => '',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'preferredbehaviour' => 'deferredfeedback',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'questionsperpage' => '0',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'timecreated' => '0',
            'timemodified' => '1278603396',
            'timelimit' => '0',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'sumgrades' => '1.00000',
            'grade' => '10.00000',
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '0',
            'introformat' => '0',
            'preferredbehaviour' => 'deferredfeedback',
            'reviewattempt' => '69904',
            'reviewcorrectness' => '69904',
            'reviewmarks' => '69904',
            'reviewspecificfeedback' => '69904',
            'reviewgeneralfeedback' => '69904',
            'reviewrightanswer' => '69904',
            'reviewoverallfeedback' => '4368',
        );
        $attempt = (object) array(
            'id' => '2',
            'uniqueid' => '2',
            'quiz' => '2',
            'userid' => '4',
            'attempt' => '1',
            'timestart' => '1278604557',
            'timefinish' => '1278604570',
            'timemodified' => '1278604597',
            'layout' => '2,0',
            'preview' => '0',
            'sumgrades' => '0.90000',
        );
        $question = (object) array(
            'id' => '2',
            'category' => '2',
            'parent' => '0',
            'name' => 'Which is the amphibian',
            'questiontext' => 'Which is the amphibian?',
            'questiontextformat' => '1',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'tjh238.vledev.open.ac.uk+100708154547+JrHygi',
            'version' => 'tjh238.vledev.open.ac.uk+100708154548+a3zh8v',
            'hidden' => '0',
            'timecreated' => '1278603947',
            'timemodified' => '1278603947',
            'createdby' => '3',
            'modifiedby' => '3',
            'defaultmark' => '1.0000000',
            'penalty' => '0.3333333',
            'maxmark' => '1.00000',
            'options' => (object) array(
                'id' => '1',
                'question' => '2',
                'layout' => '0',
                'answers' => array(
                    3 => (object) array(
                        'question' => '2',
                        'answer' => 'Cat',
                        'feedback' => '',
                        'fraction' => '0.0000000',
                        'id' => 3,
                    ),
                    4 => (object) array(
                        'question' => '2',
                        'answer' => 'Frog',
                        'feedback' => '',
                        'fraction' => '1.0000000',
                        'id' => 4,
                    ),
                    5 => (object) array(
                        'question' => '2',
                        'answer' => 'Ant',
                        'feedback' => '',
                        'fraction' => '0.0000000',
                        'id' => 5,
                    ),
                    6 => (object) array(
                        'question' => '2',
                        'answer' => 'Dog',
                        'feedback' => '',
                        'fraction' => '0.0000000',
                        'id' => 6,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '1',
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
                'answernumbering' => 'none',
                'showstandardinstruction' => 0,
                'shownumcorrect' => '0',
            ),
            'hints' => array (
                1 => (object) array(
                    'hint' => 'First hint',
                    'questionid' => '2',
                    'shownumcorrect' => null,
                    'clearwrong' => null,
                    'options' => null,
                    'id' => 1,
                ),
                2 => (object) array(
                    'hint' => 'Second hint',
                    'questionid' => '2',
                    'shownumcorrect' => null,
                    'clearwrong' => null,
                    'options' => null,
                    'id' => 2,
                ),
            ),
        );
        $qsession = (object) array(
            'id' => '2',
            'attemptid' => '2',
            'questionid' => '2',
            'newest' => '6',
            'newgraded' => '6',
            'sumpenalty' => '0.3333333',
            'manualcomment' => 'Well done!',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            0 => (object) array(
                'id' => '4',
                'attempt' => '2',
                'question' => '2',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '5,4,6,3:',
                'timestamp' => '1278604557',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
            ),
            1 => (object) array(
                'id' => '5',
                'attempt' => '2',
                'question' => '2',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '5,4,6,3:4',
                'timestamp' => '1278604562',
                'event' => '6',
                'grade' => '1',
                'raw_grade' => '1',
                'penalty' => '0.3333333',
            ),
            2 => (object) array(
                'id' => '6',
                'attempt' => '2',
                'question' => '2',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '5,4,6,3:4',
                'timestamp' => '1278604597',
                'event' => '9',
                'grade' => '0.9',
                'raw_grade' => '0.9',
                'penalty' => '0',
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 2,
            'variant' => 1,
            'maxmark' => 1,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'Which is the amphibian?',
            'rightanswer' => 'Frog',
            'responsesummary' => 'Frog',
            'timemodified' => 1278604597,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1278604557,
                    'userid' => 4,
                    'data' => array('_order' => '5,4,6,3'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'gradedright',
                    'fraction' => 1,
                    'timecreated' => 1278604562,
                    'userid' => 4,
                    'data' => array('-finish' => '1', 'answer' => '1'),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'mangrpartial',
                    'fraction' => 0.9,
                    'timecreated' => 1278604597,
                    'userid' => null,
                    'data' => array('-comment' => 'Well done!', '-mark' => '0.9', '-maxmark' => 1),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_history0() {
        $quiz = (object) array(
            'id' => '8',
            'course' => '1095',
            'name' => 'End of course quiz',
            'intro' => 'Use this self-assessment quiz to judge your overall understanding. ',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '1150107600',
            'timeclose' => '0',
            'preferredbehaviour' => 'deferredfeedback',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'review' => '71760879',
            'questionsperpage' => '0',
            'shufflequestions' => '1',
            'shuffleanswers' => '1',
            'sumgrades' => '25',
            'grade' => '25',
            'timecreated' => '0',
            'timemodified' => '1150107596',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
        );
        $attempt = (object) array(
            'id' => '17',
            'uniqueid' => '17',
            'quiz' => '8',
            'userid' => '26290',
            'attempt' => '1',
            'sumgrades' => '0',
            'timestart' => '1150203042',
            'timefinish' => '0',
            'timemodified' => '1150203042',
            'layout' => '93,76,82,75,87,74,90,94,73,77,81,95,79,92,88,80,91,86,72,83,84,89,85,78,71,0',
            'preview' => '1',
        );
        $question = (object) array(
            'id' => '72',
            'category' => '10',
            'parent' => '0',
            'name' => 'Q02',
            'questiontext' => 'Why were standards such an important driver in the growth of systems integration?',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '0.1',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+060612113403+Fz0GGO',
            'version' => 'learn.open.ac.uk+060612160802+I6ctMQ',
            'hidden' => '0',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'timecreated' => '0',
            'timemodified' => '0',
            'createdby' => null,
            'modifiedby' => null,
            'unlimited' => null,
            'maxmark' => '1',
            'options' => (object) array(
                'id' => '44',
                'question' => '72',
                'layout' => '0',
                'answers' => array(
                    200 => (object) array(
                        'question' => '72',
                        'answer' => 'Because they enable stored data and interfaces to be standardised.',
                        'fraction' => '1',
                        'feedback' => 'Standards enable the various components of an integrated system to communicate using well defined mechanisms and enable the components to have a standard view of stored data.',
                        'id' => 200,
                    ),
                    201 => (object) array(
                        'question' => '72',
                        'answer' => 'Because they enable the members of an integration team to communicate together.',
                        'fraction' => '0',
                        'feedback' => 'Standards enable the various components of an integrated system to communicate using well defined mechanisms and enable the components to have a standard view of stored data.',
                        'id' => 201,
                    ),
                    202 => (object) array(
                        'question' => '72',
                        'answer' => 'Because they produce good quality documentation.',
                        'fraction' => '0',
                        'feedback' => 'Standards enable the various components of an integrated system to communicate using well defined mechanisms and enable the components to have a standard view of stored data.',
                        'id' => 202,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '1',
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '132',
            'attemptid' => '17',
            'questionid' => '72',
            'newest' => '196',
            'newgraded' => '196',
            'sumpenalty' => '0',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            196 => (object) array(
                'attempt' => '17',
                'question' => '72',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '200,202,201:',
                'timestamp' => '1150203042',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 196,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 72,
            'variant' => 1,
            'maxmark' => 1,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'Why were standards such an important driver in the growth of systems integration?',
            'rightanswer' => 'Because they enable stored data and interfaces to be standardised.',
            'responsesummary' => '',
            'timemodified' => 1150203042,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1150203042,
                    'userid' => 26290,
                    'data' => array('_order' => '200,202,201'),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_history60() {
        $quiz = (object) array(
            'id' => '13',
            'course' => '1416',
            'name' => 'Self assessment',
            'intro' => '<p>This quiz enables you to rate how much you have demonstrated certain skills in assignments.
        </p>
        <p>Each question is phrased so that you agree or disagree with a statement that describes your level of attainment, and is accompanied by a link to advice on recognising and practising the skill.
        </p>
        <p>The quiz is intended to form part of a dialogue on skills improvement between you and your tutor. Hence there is no "right" answer to it, and it is awarded no marks towards the course result.
        </p>
        <p>Any benefits to you depend on your being realistic about what you have demonstrated. Reserve the extreme ratings for when you think you have demonstrated mastery or complete incompetence!
            <br />
        </p>',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'preferredbehaviour' => 'deferredfeedback',
            'attempts' => '0',
            'attemptonlast' => '1',
            'grademethod' => '4',
            'decimalpoints' => '0',
            'review' => '71760879',
            'questionsperpage' => '0',
            'shufflequestions' => '0',
            'shuffleanswers' => '0',
            'sumgrades' => '7',
            'grade' => '0',
            'timecreated' => '0',
            'timemodified' => '1160991947',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
        );
        $attempt = (object) array(
            'id' => '181',
            'uniqueid' => '181',
            'quiz' => '13',
            'userid' => '9932',
            'attempt' => '1',
            'sumgrades' => '0',
            'timestart' => '1161946984',
            'timefinish' => '1161947130',
            'timemodified' => '1161947130',
            'layout' => '218,221,219,220,223,224,222,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '218',
            'category' => '21',
            'parent' => '0',
            'name' => 'Answering the question that is asked',
            'questiontext' => '<p>I have demonstrated the ability to analyse and <strong>answer the question</strong> that is asked. (<a title="Advice" href="http://learnacct.open.ac.uk/mod/resourcepage/view.php?id=5989">Click for advice on this skill</a>)',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '0',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+060822084343+5JvlNr',
            'version' => 'learn.open.ac.uk+060822084343+CQPfhb',
            'hidden' => '0',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'timecreated' => '0',
            'timemodified' => '0',
            'createdby' => null,
            'modifiedby' => null,
            'unlimited' => null,
            'maxmark' => '1',
            'options' => (object) array(
                'id' => '152',
                'question' => '218',
                'layout' => '0',
                'answers' => array(
                    664 => (object) array(
                        'question' => '218',
                        'answer' => 'Agree',
                        'fraction' => '0',
                        'feedback' => ' ',
                        'id' => 664,
                    ),
                    665 => (object) array(
                        'question' => '218',
                        'answer' => 'Uncertain',
                        'fraction' => '0',
                        'feedback' => ' ',
                        'id' => 665,
                    ),
                    666 => (object) array(
                        'question' => '218',
                        'answer' => 'Disagree',
                        'fraction' => '0',
                        'feedback' => ' ',
                        'id' => 666,
                    ),
                    667 => (object) array(
                        'question' => '218',
                        'answer' => 'Strongly disagree',
                        'fraction' => '0',
                        'feedback' => ' ',
                        'id' => 667,
                    ),
                    668 => (object) array(
                        'question' => '218',
                        'answer' => 'Strongly agree',
                        'fraction' => '0',
                        'feedback' => ' ',
                        'id' => 668,
                    ),
                ),
                'single' => '0',
                'shuffleanswers' => '0',
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '2412',
            'attemptid' => '181',
            'questionid' => '218',
            'newest' => '3891',
            'newgraded' => '3891',
            'sumpenalty' => '0',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            3888 => (object) array(
                'attempt' => '181',
                'question' => '218',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '664,665,666,667,668:',
                'timestamp' => '1161946984',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 3888,
            ),
            3891 => (object) array(
                'attempt' => '181',
                'question' => '218',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '664,665,666,667,668:664',
                'timestamp' => '1161947130',
                'event' => '6',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 3891,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 218,
            'variant' => 1,
            'maxmark' => 1,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'I have demonstrated the ability to analyse and ANSWER THE QUESTION that is asked. (Click for advice on this skill)',
            'rightanswer' => '',
            'responsesummary' => 'Agree',
            'timemodified' => 1161947130,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1161946984,
                    'userid' => 9932,
                    'data' => array('_order' => '664,665,666,667,668'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'gradedwrong',
                    'fraction' => 0,
                    'timecreated' => 1161947130,
                    'userid' => 9932,
                    'data' => array('choice0' => 1, 'choice1' => 0, 'choice2' => 0, 'choice3' => 0, 'choice4' => 0, '-finish' => 1),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_history6220() {
        $quiz = (object) array(
            'id' => '95',
            'course' => '1181',
            'name' => 'Study Guide 7 Quiz',
            'intro' => '',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'preferredbehaviour' => 'deferredfeedback',
            'attempts' => '0',
            'attemptonlast' => '1',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'review' => '71760879',
            'questionsperpage' => '2',
            'shufflequestions' => '0',
            'shuffleanswers' => '0',
            'sumgrades' => '59',
            'grade' => '59',
            'timecreated' => '0',
            'timemodified' => '1170427431',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
        );
        $attempt = (object) array(
            'id' => '3237',
            'uniqueid' => '3237',
            'quiz' => '95',
            'userid' => '120555',
            'attempt' => '1',
            'sumgrades' => '35.4166',
            'timestart' => '1177006492',
            'timefinish' => '1177008802',
            'timemodified' => '1177008794',
            'layout' => '2855,2856,0,2857,2858,0,2859,2860,0,2861,2862,0,2863,2864,0,2865,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '2855',
            'category' => '114',
            'parent' => '0',
            'name' => 'Question 1',
            'questiontext' => '<p>Which of the following techniques can identify non-functional requirements?</p>',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '0',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+061221143845+nohATp',
            'version' => 'learn.open.ac.uk+070131102906+bviJOZ',
            'hidden' => '0',
            'generalfeedback' => 'The correct answers are b and c.
        For further information about this question see Study Guide 7 SAQ 2.1(b and c)
        Misuse cases were discussed in SG4',
            'generalfeedbackformat' => '1',
            'timecreated' => '0',
            'timemodified' => '0',
            'createdby' => null,
            'modifiedby' => null,
            'unlimited' => null,
            'maxmark' => '5',
            'options' => (object) array(
                'id' => '943',
                'question' => '2855',
                'layout' => '0',
                'answers' => array(
                    8356 => (object) array(
                        'question' => '2855',
                        'answer' => 'Use cases.',
                        'fraction' => '-0.33333',
                        'feedback' => '',
                        'id' => 8356,
                    ),
                    8357 => (object) array(
                        'question' => '2855',
                        'answer' => 'Verb identification.',
                        'fraction' => '0.5',
                        'feedback' => '',
                        'id' => 8357,
                    ),
                    8358 => (object) array(
                        'question' => '2855',
                        'answer' => 'Misuse cases.',
                        'fraction' => '0.5',
                        'feedback' => '',
                        'id' => 8358,
                    ),
                    8359 => (object) array(
                        'question' => '2855',
                        'answer' => 'Adjective identification.',
                        'fraction' => '-0.33333',
                        'feedback' => '',
                        'id' => 8359,
                    ),
                    8360 => (object) array(
                        'question' => '2855',
                        'answer' => 'Noun identification.',
                        'fraction' => '-0.33333',
                        'feedback' => '',
                        'id' => 8360,
                    ),
                ),
                'single' => '0',
                'shuffleanswers' => '0',
                'correctfeedback' => 'Your answer is correct.',
                'partiallycorrectfeedback' => 'Your answer is partially correct.',
                'incorrectfeedback' => 'Your answer is incorrect.',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '30584',
            'attemptid' => '3237',
            'questionid' => '2855',
            'newest' => '72341',
            'newgraded' => '72341',
            'sumpenalty' => '0',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            72307 => (object) array(
                'attempt' => '3237',
                'question' => '2855',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '8356,8357,8358,8359,8360:',
                'timestamp' => '1177006492',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 72307,
            ),
            72318 => (object) array(
                'attempt' => '3237',
                'question' => '2855',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '8356,8357,8358,8359,8360:8357,8359',
                'timestamp' => '1177007066',
                'event' => '2',
                'grade' => '0',
                'raw_grade' => '0.83335',
                'penalty' => '0',
                'id' => 72318,
            ),
            72328 => (object) array(
                'attempt' => '3237',
                'question' => '2855',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '8356,8357,8358,8359,8360:8357,8359',
                'timestamp' => '1177008016',
                'event' => '2',
                'grade' => '0',
                'raw_grade' => '0.83335',
                'penalty' => '0',
                'id' => 72328,
            ),
            72341 => (object) array(
                'attempt' => '3237',
                'question' => '2855',
                'originalquestion' => '0',
                'seq_number' => '3',
                'answer' => '8356,8357,8358,8359,8360:8357,8359',
                'timestamp' => '1177008016',
                'event' => '6',
                'grade' => '0.83335',
                'raw_grade' => '0.83335',
                'penalty' => '0',
                'id' => 72341,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 2855,
            'variant' => 1,
            'maxmark' => 5,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'Which of the following techniques can identify non-functional requirements?',
            'rightanswer' => 'Verb identification.; Misuse cases.',
            'responsesummary' => 'Verb identification.; Adjective identification.',
            'timemodified' => 1177008016,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1177006492,
                    'userid' => 120555,
                    'data' => array('_order' => '8356,8357,8358,8359,8360'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'complete',
                    'fraction' => null,
                    'timecreated' => 1177007066,
                    'userid' => 120555,
                    'data' => array('choice0' => 0, 'choice1' => 1, 'choice2' => 0, 'choice3' => 1, 'choice4' => 0),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'complete',
                    'fraction' => null,
                    'timecreated' => 1177008016,
                    'userid' => 120555,
                    'data' => array('choice0' => 0, 'choice1' => 1, 'choice2' => 0, 'choice3' => 1, 'choice4' => 0),
                ),
                3 => (object) array(
                    'sequencenumber' => 3,
                    'state' => 'gradedpartial',
                    'fraction' => 0.16667,
                    'timecreated' => 1177008016,
                    'userid' => 120555,
                    'data' => array('choice0' => 0, 'choice1' => 1, 'choice2' => 0, 'choice3' => 1, 'choice4' => 0, '-finish' => 1),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_missing() {
        $quiz = (object) array(
            'id' => '8',
            'course' => '1095',
            'name' => 'End of course quiz',
            'intro' => 'Use this self-assessment quiz to judge your overall understanding. ',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '1150107600',
            'timeclose' => '0',
            'preferredbehaviour' => 'deferredfeedback',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'review' => '71760879',
            'questionsperpage' => '0',
            'shufflequestions' => '1',
            'shuffleanswers' => '1',
            'sumgrades' => '25',
            'grade' => '25',
            'timecreated' => '0',
            'timemodified' => '1150107596',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
        );
        $attempt = (object) array(
            'id' => '17',
            'uniqueid' => '17',
            'quiz' => '8',
            'userid' => '26290',
            'attempt' => '1',
            'sumgrades' => '0',
            'timestart' => '1150203042',
            'timefinish' => '0',
            'timemodified' => '1150203042',
            'layout' => '93,76,82,75,87,74,90,94,73,77,81,95,79,92,88,80,91,86,72,83,84,89,85,78,71,0',
            'preview' => '1',
        );
        $question = (object) array(
            'id' => '72',
            'category' => '10',
            'parent' => '0',
            'name' => 'Q02',
            'questiontext' => 'Why were standards such an important driver in the growth of systems integration?',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '0.1',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+060612113403+Fz0GGO',
            'version' => 'learn.open.ac.uk+060612160802+I6ctMQ',
            'hidden' => '0',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'timecreated' => '0',
            'timemodified' => '0',
            'createdby' => null,
            'modifiedby' => null,
            'unlimited' => null,
            'maxmark' => '1',
            'options' => (object) array(
                'id' => '44',
                'question' => '72',
                'layout' => '0',
                'answers' => array(
                    200 => (object) array(
                        'question' => '72',
                        'answer' => 'Because they enable stored data and interfaces to be standardised.',
                        'fraction' => '1',
                        'feedback' => 'Standards enable the various components of an integrated system to communicate using well defined mechanisms and enable the components to have a standard view of stored data.',
                        'id' => 200,
                    ),
                    201 => (object) array(
                        'question' => '72',
                        'answer' => 'Because they enable the members of an integration team to communicate together.',
                        'fraction' => '0',
                        'feedback' => 'Standards enable the various components of an integrated system to communicate using well defined mechanisms and enable the components to have a standard view of stored data.',
                        'id' => 201,
                    ),
                    202 => (object) array(
                        'question' => '72',
                        'answer' => 'Because they produce good quality documentation.',
                        'fraction' => '0',
                        'feedback' => 'Standards enable the various components of an integrated system to communicate using well defined mechanisms and enable the components to have a standard view of stored data.',
                        'id' => 202,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '1',
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );

        $qa = $this->updater->supply_missing_question_attempt($quiz, $attempt, $question);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 72,
            'variant' => 1,
            'maxmark' => 1,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'Why were standards such an important driver in the growth of systems integration?',
            'rightanswer' => 'Because they enable stored data and interfaces to be standardised.',
            'responsesummary' => '',
            'timemodified' => 1150203042,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1150203042,
                    'userid' => 26290,
                    'data' => array('_order' => '200,201,202'),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

public function test_multichoice_deferredfeedback_qsession140() {
        $quiz = (object) array(
            'id' => '58',
            'course' => '3420',
            'name' => 'Practice Quiz',
            'intro' => '',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'optionflags' => '0',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '3',
            'decimalpoints' => '2',
            'review' => '71760879',
            'questionsperpage' => '2',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'sumgrades' => '10',
            'grade' => '10',
            'timecreated' => '0',
            'timemodified' => '1200043605',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
            'preferredbehaviour' => 'deferredfeedback',
        );
        $attempt = (object) array(
            'id' => '38',
            'uniqueid' => '38',
            'quiz' => '58',
            'userid' => '51335',
            'attempt' => '1',
            'sumgrades' => '5',
            'timestart' => '1198254245',
            'timefinish' => '1198254438',
            'timemodified' => '1198254352',
            'layout' => '178,179,180,181,182,183,184,185,189,187,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '179',
            'category' => '51',
            'parent' => '0',
            'name' => 'Question 2',
            'questiontext' => '<p>Where will the 19th International Biology Olympiad be held?</p>',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '0.1',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'openlearn.open.ac.uk+071210172238+HpCRWO',
            'version' => 'openlearn.open.ac.uk+071211115640+SZulvf',
            'hidden' => '0',
            'generalfeedback' => '<p></p>',
            'generalfeedbackformat' => '1',
            'timecreated' => '0',
            'timemodified' => '0',
            'createdby' => null,
            'modifiedby' => null,
            'unlimited' => null,
            'maxmark' => '1',
            'options' => (object) array(
                'id' => '71',
                'question' => '179',
                'layout' => '0',
                'answers' => array(
                    372 => (object) array(
                        'question' => '179',
                        'answer' => 'Mumbai, India',
                        'fraction' => '1',
                        'feedback' => '',
                        'id' => 372,
                    ),
                    373 => (object) array(
                        'question' => '179',
                        'answer' => 'Rome, Italy',
                        'fraction' => '-1',
                        'feedback' => '',
                        'id' => 373,
                    ),
                    374 => (object) array(
                        'question' => '179',
                        'answer' => 'Oslo, Norway',
                        'fraction' => '-1',
                        'feedback' => '',
                        'id' => 374,
                    ),
                    375 => (object) array(
                        'question' => '179',
                        'answer' => 'Tokyo, Japan',
                        'fraction' => '-1',
                        'feedback' => '',
                        'id' => 375,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '1',
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '140',
            'attemptid' => '38',
            'questionid' => '179',
            'newest' => '273',
            'newgraded' => '273',
            'sumpenalty' => '0.2',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            243 => (object) array(
                'attempt' => '38',
                'question' => '179',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '375,372,374,373:',
                'timestamp' => '1198254245',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 243,
            ),
            254 => (object) array(
                'attempt' => '38',
                'question' => '179',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '375,372,374,373:375',
                'timestamp' => '1198254261',
                'event' => '3',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0.1',
                'id' => 254,
            ),
            273 => (object) array(
                'attempt' => '38',
                'question' => '179',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '375,372,374,373:375',
                'timestamp' => '1198254261',
                'event' => '6',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0.1',
                'id' => 273,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 179,
            'variant' => 1,
            'maxmark' => 1,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'Where will the 19th International Biology Olympiad be held?',
            'rightanswer' => 'Mumbai, India',
            'responsesummary' => 'Tokyo, Japan',
            'timemodified' => 1198254261,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1198254245,
                    'userid' => 51335,
                    'data' => array('_order' => '375,372,374,373'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'gradedwrong',
                    'fraction' => 0,
                    'timecreated' => 1198254261,
                    'userid' => 51335,
                    'data' => array('answer' => '0', '-finish' => '1'),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_qsession2018195() {
        $quiz = (object) array(
            'id' => '1832',
            'course' => '4912',
            'name' => 'Unit 12 IL & ICT review quiz',
            'intro' => '<p>This quiz has been developed to help you review your skills development in information literacy and ICT and to gather feedback on the use of the skills activities within K315 and within the Social Work degree Practice Learning courses.</p>
        <p>We would welcome your input (allow 10-15 minutes). The data you provide will be anonymised and used for research purposes only. This project is administered under the OU’s general data protection policy guidelines, which can be seen here: <a href="http://www3.open.ac.uk/our-student-policies/pdf/dataprotection.pdf">http://www3.open.ac.uk/our-student-policies/pdf/dataprotection.pdf</a></p>',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'optionflags' => '0',
            'penaltyscheme' => '1',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'review' => '71565312',
            'questionsperpage' => '2',
            'shufflequestions' => '0',
            'shuffleanswers' => '0',
            'sumgrades' => '0',
            'grade' => '0',
            'timecreated' => '0',
            'timemodified' => '1232636874',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
            'preferredbehaviour' => 'deferredfeedback',
        );
        $attempt = (object) array(
            'id' => '174744',
            'uniqueid' => '174745',
            'quiz' => '1832',
            'userid' => '181806',
            'attempt' => '1',
            'sumgrades' => '0',
            'timestart' => '1249488674',
            'timefinish' => '1250702880',
            'timemodified' => '1249488674',
            'layout' => '26132,26128,0,26143,26140,0,26144,26141,0,26145,26142,0,26126,26127,0,26134,26135,0,26131,26133,0,26130,26129,0,26136,26137,0,26139,26138,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '26132',
            'category' => '2506',
            'parent' => '0',
            'name' => '01 most useful',
            'questiontext' => 'Which was the most useful K315 information literacy or ICT activity?',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '0.1',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+080529101041+d4XuNI',
            'version' => 'learn.open.ac.uk+100725192556+KIetVC',
            'hidden' => '0',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'timecreated' => '1212055841',
            'timemodified' => '1280085956',
            'createdby' => '28856',
            'modifiedby' => '25299',
            'unlimited' => '0',
            'maxmark' => '0',
            'options' => (object) array(
                'id' => '11628',
                'question' => '26132',
                'layout' => '0',
                'answers' => array(
                    77406 => (object) array(
                        'question' => '26132',
                        'answer' => 'Introduction to & evaluation of MyStuff (Course Introduction)',
                        'fraction' => '0',
                        'feedback' => '',
                        'id' => 77406,
                    ),
                    77407 => (object) array(
                        'question' => '26132',
                        'answer' => 'Values Exchange case studies',
                        'fraction' => '1',
                        'feedback' => '',
                        'id' => 77407,
                    ),
                    77408 => (object) array(
                        'question' => '26132',
                        'answer' => 'Secure accommodation orders (Unit 2, Activity 3.3)',
                        'fraction' => '0',
                        'feedback' => '',
                        'id' => 77408,
                    ),
                    77409 => (object) array(
                        'question' => '26132',
                        'answer' => 'Advanced search tools (Unit 3, Activity 1.3)',
                        'fraction' => '0',
                        'feedback' => '',
                        'id' => 77409,
                    ),
                    77410 => (object) array(
                        'question' => '26132',
                        'answer' => 'Different types of information (Unit 7, Activity 1.2)',
                        'fraction' => '0',
                        'feedback' => '',
                        'id' => 77410,
                    ),
                    77411 => (object) array(
                        'question' => '26132',
                        'answer' => 'Informing your practice with empirical evidence (Unit 8, Activity 3.1)',
                        'fraction' => '0',
                        'feedback' => '',
                        'id' => 77411,
                    ),
                    77412 => (object) array(
                        'question' => '26132',
                        'answer' => 'Reviewing and saving your work (Unit 12, Activity 2.2)',
                        'fraction' => '0',
                        'feedback' => '',
                        'id' => 77412,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '0',
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '2018195',
            'attemptid' => '174745',
            'questionid' => '26132',
            'newest' => '5162301',
            'newgraded' => '5162301',
            'sumpenalty' => '0',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            5107187 => (object) array(
                'attempt' => '174745',
                'question' => '26132',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '77406,77407,77408,77409,77410,77411,77412:',
                'timestamp' => '1249488674',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 5107187,
            ),
            5107188 => (object) array(
                'attempt' => '174745',
                'question' => '26132',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '',
                'timestamp' => '1249488674',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 5107188,
            ),
            5107190 => (object) array(
                'attempt' => '174745',
                'question' => '26132',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '77406,77407,77408,77409,77410,77411,77412:77407',
                'timestamp' => '1249488763',
                'event' => '2',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 5107190,
            ),
            5162301 => (object) array(
                'attempt' => '174745',
                'question' => '26132',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '77406,77407,77408,77409,77410,77411,77412:77407',
                'timestamp' => '1249488763',
                'event' => '6',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 5162301,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 26132,
            'variant' => 1,
            'maxmark' => 0,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'Which was the most useful K315 information literacy or ICT activity?',
            'rightanswer' => 'Values Exchange case studies',
            'responsesummary' => 'Values Exchange case studies',
            'timemodified' => 1249488763,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1249488674,
                    'userid' => 181806,
                    'data' => array('_order' => '77406,77407,77408,77409,77410,77411,77412'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'complete',
                    'fraction' => null,
                    'timecreated' => 1249488763,
                    'userid' => 181806,
                    'data' => array('answer' => '1'),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'finished',
                    'fraction' => null,
                    'timecreated' => 1249488763,
                    'userid' => 181806,
                    'data' => array('answer' => '1', '-finish' => '1'),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_qsession2653368() {
        $quiz = (object) array(
            'id' => '3273',
            'course' => '5862',
            'name' => 'Assessing information sources',
            'intro' => 'Assessing information sources - literature review table',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'optionflags' => '0',
            'penaltyscheme' => '1',
            'attempts' => '0',
            'attemptonlast' => '1',
            'grademethod' => '4',
            'decimalpoints' => '2',
            'review' => '71727591',
            'questionsperpage' => '0',
            'shufflequestions' => '0',
            'shuffleanswers' => '0',
            'questions' => '60135,60136,60137,0',
            'sumgrades' => '3',
            'grade' => '10',
            'timecreated' => '0',
            'timemodified' => '1223992271',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
            'preferredbehaviour' => 'deferredfeedback',
        );
        $attempt = (object) array(
            'id' => '229025',
            'uniqueid' => '229026',
            'quiz' => '3273',
            'userid' => '597153',
            'attempt' => '4',
            'sumgrades' => '0.999999',
            'timestart' => '1258492857',
            'timefinish' => '1258492862',
            'timemodified' => '1258492857',
            'layout' => '60135,60136,60137,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '60137',
            'category' => '6026',
            'parent' => '0',
            'name' => 'Assessing information sources - No. 3',
            'questiontext' => 'For source 3, the \'Loose Change\' video, select the statements to indicate \'yes\':',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '0.1',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+080811153454+BMEq1t',
            'version' => 'learn.open.ac.uk+081010072800+oSu1g3',
            'hidden' => '0',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'timecreated' => '1218468894',
            'timemodified' => '1223623680',
            'createdby' => '26409',
            'modifiedby' => '351133',
            'unlimited' => null,
            'maxmark' => '1',
            'options' => (object) array(
                'id' => '23896',
                'question' => '60137',
                'layout' => '0',
                'answers' => array(
                    181821 => (object) array(
                        'question' => '60137',
                        'answer' => 'Would you regard this source as objective?',
                        'fraction' => '0.142857',
                        'feedback' => '',
                        'id' => 181821,
                    ),
                    181822 => (object) array(
                        'question' => '60137',
                        'answer' => 'Does the source provide references?',
                        'fraction' => '0.142857',
                        'feedback' => '',
                        'id' => 181822,
                    ),
                    181823 => (object) array(
                        'question' => '60137',
                        'answer' => 'Are all viewpoints considered?',
                        'fraction' => '0.142857',
                        'feedback' => '',
                        'id' => 181823,
                    ),
                    181824 => (object) array(
                        'question' => '60137',
                        'answer' => 'Are quotations placed in their full context?',
                        'fraction' => '0.142857',
                        'feedback' => '',
                        'id' => 181824,
                    ),
                    181825 => (object) array(
                        'question' => '60137',
                        'answer' => 'Does the source include conclusions based on evidence?',
                        'fraction' => '0.142857',
                        'feedback' => '',
                        'id' => 181825,
                    ),
                    181826 => (object) array(
                        'question' => '60137',
                        'answer' => 'Would you trust this source?',
                        'fraction' => '0.142857',
                        'feedback' => '',
                        'id' => 181826,
                    ),
                    181827 => (object) array(
                        'question' => '60137',
                        'answer' => 'Has it been peer-reviewed?',
                        'fraction' => '0.142857',
                        'feedback' => '',
                        'id' => 181827,
                    ),
                ),
                'single' => '0',
                'shuffleanswers' => '0',
                'correctfeedback' => 'This is a very polemical source which clearly has a standpoint. Whether or not you would use this material would be largely dependent on your reseach question. If you did use it, you would need to be clear that you would require academic sources that would support the claims being made.<br />',
                'partiallycorrectfeedback' => 'This is a very polemical source which clearly has a standpoint. Whether or not you would use this material would be largely dependent on your reseach question. If you did use it, you would need to be clear that you would require academic sources that would support the claims being made.<br /><br />',
                'incorrectfeedback' => 'This is a very polemical source which clearly has a standpoint. Whether or not you would use this material would be largely dependent on your reseach question. If you did use it, you would need to be clear that you would require academic sources that would support the claims being made.<br /><br />',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '2653368',
            'attemptid' => '229026',
            'questionid' => '60137',
            'newest' => '6676055',
            'newgraded' => '6676055',
            'sumpenalty' => '0.1',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            6676031 => (object) array(
                'attempt' => '229026',
                'question' => '60137',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '181821,181822,181823,181824,181825,181826,181827:181821,181822,181823,181824,181825,181826',
                'timestamp' => '1258492857',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0.857142',
                'penalty' => '0',
                'id' => 6676031,
            ),
            6676034 => (object) array(
                'attempt' => '229026',
                'question' => '60137',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '181821,181822,181823,181824,181825,181826,181827:',
                'timestamp' => '1258492857',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0.1',
                'id' => 6676034,
            ),
            6676055 => (object) array(
                'attempt' => '229026',
                'question' => '60137',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '181821,181822,181823,181824,181825,181826,181827:',
                'timestamp' => '1258492857',
                'event' => '6',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0.1',
                'id' => 6676055,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 60137,
            'variant' => 1,
            'maxmark' => 1,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => "For source 3, the 'Loose Change' video, select the statements to indicate 'yes':",
            'rightanswer' => 'Would you regard this source as objective?; Does the source provide references?; Are all viewpoints considered?; Are quotations placed in their full context?; Does the source include conclusions based on evidence?; Would you trust this source?; Has it been peer-reviewed?',
            'responsesummary' => 'Would you regard this source as objective?; Does the source provide references?; Are all viewpoints considered?; Are quotations placed in their full context?; Does the source include conclusions based on evidence?; Would you trust this source?',
            'timemodified' => 1258492857,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1258492857,
                    'userid' => 597153,
                    'data' => array('_order' => '181821,181822,181823,181824,181825,181826,181827'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'gradedwrong',
                    'fraction' => 0,
                    'timecreated' => 1258492857,
                    'userid' => 597153,
                    'data' => array('choice0' => 0, 'choice1' => 0, 'choice2' => 0, 'choice3' => 0, 'choice4' => 0, 'choice5' => 0, 'choice6' => 0, '-finish' => '1'),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_qsession3131() {
        $quiz = (object) array(
            'id' => '10',
            'course' => '608',
            'name' => 'TMA 01, Part 1 (Activity 12)',
            'intro' => '<p>Activity 12 is a multiple-choice assessment quiz. It is Part 1 of TMA 01 and contributes 20 per cent of the marks for the TMA. It invites you to check your understandings of the topics with which you engaged in Activities 6–11.</p>

        <p>Activity 12 is distinctive in that you are welcome to try as much as you want at any one time and to try as often as you wish. However, you have to get <strong>full marks</strong> on it in order to proceed to the second part of TMA 01, Activity 15.</p>

        <p>There are 30 questions, which can be attempted in any order. When you are ready to attempt a question, choose your answer and then \'Submit\'. You will get feedback. If you need to try again, follow the same process. When you are satisfied with your answer to one question, go on to another. Remember to choose \'Submit\' for each answer that you want to be saved.</p>

        <p>You do not have to do the questions all at one sitting: at any time you can choose \'Save without submitting\'. This saves the current state of all questions so you can come back later to do some more.</p>

        <p>When you are satisfied with your answers to all 30 questions, choose \'Submit all and finish\'. This marks all questions, closes the current quiz attempt and gives the PCAP team formal notification that you have successfully completed this part of the TMA. <strong>Should you inadvertently choose this option you will need to start from scratch when you next attempt the task.</strong></p>',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'optionflags' => '0',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '2',
            'decimalpoints' => '2',
            'review' => '71760879',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'sumgrades' => '30',
            'grade' => '10',
            'timecreated' => '0',
            'timemodified' => '1266247621',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
            'preferredbehaviour' => 'deferredfeedback',
        );
        $attempt = (object) array(
            'id' => '302',
            'uniqueid' => '302',
            'quiz' => '10',
            'userid' => '63173',
            'attempt' => '1',
            'sumgrades' => '30',
            'timestart' => '1163428543',
            'timefinish' => '1166546613',
            'timemodified' => '1166546472',
            'layout' => '161,0,160,0,162,0,163,0,164,0,165,0,166,0,190,0,191,0,192,0,193,0,194,0,195,0,196,0,197,0,198,0,168,0,169,0,170,0,171,0,172,0,173,0,174,0,175,0,176,0,177,0,178,0,179,0,180,0,181,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '163',
            'category' => '15',
            'parent' => '0',
            'name' => 'Question 04',
            'questiontext' => 'Can we have a \'realist\' or objective social science?',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '1',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+060614160624+gkAYii',
            'version' => 'learn.open.ac.uk+060614160624+LYm8Rl',
            'hidden' => '0',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'timecreated' => '0',
            'timemodified' => '0',
            'createdby' => null,
            'modifiedby' => null,
            'unlimited' => null,
            'maxmark' => '1',
            'options' => (object) array(
                'id' => '117',
                'question' => '163',
                'layout' => '0',
                'answers' => array(
                    456 => (object) array(
                        'question' => '163',
                        'answer' => 'No',
                        'fraction' => '0',
                        'feedback' => 'This is a common position but it does overlook areas in which it is possible to observe, tally and describe in pretty objective (low-inference) ways. Much social geography is of this sort.',
                        'id' => 456,
                    ),
                    457 => (object) array(
                        'question' => '163',
                        'answer' => 'Yes',
                        'fraction' => '0',
                        'feedback' => 'A great deal of social science is to do with making sense of subjective phenomena. We might expect social scientists to be honest and careful but, where subjective phenomena are concerned there can be no objective truth. However, there are areas in which it is possible to observe, tally and describe in pretty objective (low-inference) ways. Much social geography is of this sort.',
                        'id' => 457,
                    ),
                    458 => (object) array(
                        'question' => '163',
                        'answer' => 'Sometimes',
                        'fraction' => '1',
                        'feedback' => 'This is a judicious response to two positions, each of which has strengths but neither of which covers the range of social science practices.',
                        'id' => 458,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '0',
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '3131',
            'attemptid' => '302',
            'questionid' => '163',
            'newest' => '14715',
            'newgraded' => '14715',
            'sumpenalty' => '0',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            5922 => (object) array(
                'attempt' => '302',
                'question' => '163',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '456,457,458:',
                'timestamp' => '1163428543',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 5922,
            ),
            5941 => (object) array(
                'attempt' => '302',
                'question' => '163',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '456,457,458:',
                'timestamp' => '1163428576',
                'event' => '2',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '1',
                'id' => 5941,
            ),
            5942 => (object) array(
                'attempt' => '302',
                'question' => '163',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '456,457,458:',
                'timestamp' => '1163428577',
                'event' => '2',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '1',
                'id' => 5942,
            ),
            14713 => (object) array(
                'attempt' => '302',
                'question' => '163',
                'originalquestion' => '0',
                'seq_number' => '3',
                'answer' => '456,457,458:456',
                'timestamp' => '1165355190',
                'event' => '3',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '1',
                'id' => 14713,
            ),
            14715 => (object) array(
                'attempt' => '302',
                'question' => '163',
                'originalquestion' => '0',
                'seq_number' => '4',
                'answer' => '456,457,458:458',
                'timestamp' => '1165355352',
                'event' => '3',
                'grade' => '1',
                'raw_grade' => '1',
                'penalty' => '1',
                'id' => 14715,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 163,
            'variant' => 1,
            'maxmark' => 1,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'Can we have a \'realist\' or objective social science?',
            'rightanswer' => 'Sometimes',
            'responsesummary' => 'Sometimes',
            'timemodified' => 1165355352,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1163428543,
                    'userid' => 63173,
                    'data' => array('_order' => '456,457,458'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1163428576,
                    'userid' => 63173,
                    'data' => array(),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1163428577,
                    'userid' => 63173,
                    'data' => array(),
                ),
                3 => (object) array(
                    'sequencenumber' => 3,
                    'state' => 'gradedright',
                    'fraction' => 1,
                    'timecreated' => 1165355352,
                    'userid' => 63173,
                    'data' => array('answer' => '2', '-finish' => '1'),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_qsession4307870 () {
        $quiz = (object) array(
            'id' => '4070',
            'course' => '5139',
            'name' => 'Reading practice: Session 16',
            'intro' => '',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'optionflags' => '0',
            'penaltyscheme' => '1',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '1',
            'decimalpoints' => '0',
            'review' => '71727591',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '1',
            'sumgrades' => '8',
            'grade' => '8',
            'timecreated' => '0',
            'timemodified' => '1265136533',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
            'showscores' => '1',
            'preferredbehaviour' => 'deferredfeedback',
        );
        $attempt = (object) array(
            'id' => '428769',
            'uniqueid' => '428770',
            'quiz' => '4070',
            'userid' => '605575',
            'attempt' => '3',
            'sumgrades' => '7',
            'timestart' => '1275088684',
            'timefinish' => '1275089588',
            'timemodified' => '1275089451',
            'layout' => '89002,0,89040,0,89042,0,89043,0,89044,0,89045,0,89046,0,89047,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '89040',
            'category' => '6016',
            'parent' => '0',
            'name' => 'R2S16',
            'questiontext' => '<p>Read the text below and then answer the question based on the information given.</p><p><span lang="ZH-CN">我大哥没有我二哥高，我比我二哥高。</span></p><p>Who is the tallest?</p>',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '0.33',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+100204101142+Bygd63',
            'version' => 'learn.open.ac.uk+100204101142+exBG6F',
            'hidden' => '0',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'timecreated' => '1265278302',
            'timemodified' => '1265278302',
            'createdby' => '532546',
            'modifiedby' => '532546',
            'unlimited' => '0',
            'maxmark' => '1',
            'options' => (object) array(
                'id' => '33730',
                'question' => '89040',
                'layout' => '0',
                'answers' => array(
                    300601 => (object) array(
                        'question' => '89040',
                        'answer' => '我。',
                        'fraction' => '1',
                        'feedback' => '',
                        'id' => 300601,
                    ),
                    300602 => (object) array(
                        'question' => '89040',
                        'answer' => '我大哥。',
                        'fraction' => '0',
                        'feedback' => '',
                        'id' => 300602,
                    ),
                    300603 => (object) array(
                        'question' => '89040',
                        'answer' => '我二哥。',
                        'fraction' => '0',
                        'feedback' => '',
                        'id' => 300603,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '1',
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
                'answernumbering' => 'none',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '4307870',
            'attemptid' => '428770',
            'questionid' => '89040',
            'newest' => '11002905',
            'newgraded' => '11002905',
            'sumpenalty' => '0.33',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            11002780 => (object) array(
                'attempt' => '428770',
                'question' => '89040',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '300603,300602,300601:',
                'timestamp' => '1275088684',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 11002780,
            ),
            11002813 => (object) array(
                'attempt' => '428770',
                'question' => '89040',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '300601',
                'timestamp' => '1275089101',
                'event' => '2',
                'grade' => '0',
                'raw_grade' => '1',
                'penalty' => '0.33',
                'id' => 11002813,
            ),
            11002905 => (object) array(
                'attempt' => '428770',
                'question' => '89040',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '300603,300602,300601:300601',
                'timestamp' => '1275089101',
                'event' => '6',
                'grade' => '1',
                'raw_grade' => '1',
                'penalty' => '0.33',
                'id' => 11002905,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 89040,
            'variant' => 1,
            'maxmark' => 1,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => "Read the text below and then answer the question based on the information given.\n\n我大哥没有我二哥高，我比我二哥高。\n\nWho is the tallest?",
            'rightanswer' => '我。',
            'responsesummary' => '我。',
            'timemodified' => 1275089101,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1275088684,
                    'userid' => 605575,
                    'data' => array('_order' => '300603,300602,300601'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'complete',
                    'fraction' => null,
                    'timecreated' => 1275089101,
                    'userid' => 605575,
                    'data' => array('answer' => '2'),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'gradedright',
                    'fraction' => 1,
                    'timecreated' => 1275089101,
                    'userid' => 605575,
                    'data' => array('answer' => '2', '-finish' => '1'),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_qsession49446() {
        $quiz = (object) array(
            'id' => '203',
            'course' => '2359',
            'name' => 'Quiz 1',
            'intro' => '',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'preferredbehaviour' => 'deferredfeedback',
            'attempts' => '0',
            'attemptonlast' => '1',
            'grademethod' => '1',
            'decimalpoints' => '2',
            'review' => '71760879',
            'questionsperpage' => '2',
            'shufflequestions' => '0',
            'shuffleanswers' => '0',
            'sumgrades' => '50',
            'grade' => '50',
            'timecreated' => '0',
            'timemodified' => '1176461532',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
        );
        $attempt = (object) array(
            'id' => '4338',
            'uniqueid' => '4338',
            'quiz' => '203',
            'userid' => '30631',
            'attempt' => '2',
            'sumgrades' => '30',
            'timestart' => '1179303963',
            'timefinish' => '1179303960',
            'timemodified' => '1179303420',
            'layout' => '3859,3860,0,3861,3862,0,3863,3864,0,3865,3866,0,3867,3868,0',
            'preview' => '0',
        );
        $question = (object) array(
            'id' => '3863',
            'category' => '187',
            'parent' => '0',
            'name' => 'Question 5',
            'questiontext' => 'What is SOAP?',
            'questiontextformat' => '1',
            'defaultmark' => '1',
            'penalty' => '0',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+070404142540+CpseAv',
            'version' => 'learn.open.ac.uk+070405112519+qNb2kt',
            'hidden' => '0',
            'generalfeedback' => '<p></p>',
            'generalfeedbackformat' => '1',
            'timecreated' => '0',
            'timemodified' => '0',
            'createdby' => null,
            'modifiedby' => null,
            'unlimited' => null,
            'maxmark' => '5',
            'options' => (object) array(
                'id' => '1439',
                'question' => '3863',
                'layout' => '0',
                'answers' => array(
                    11686 => (object) array(
                        'question' => '3863',
                        'answer' => 'It is a technology used for sending bulk data through the internet.',
                        'fraction' => '0',
                        'feedback' => 'Your answer is incorrect. <br />The correct answer is b. ',
                        'id' => 11686,
                    ),
                    11687 => (object) array(
                        'question' => '3863',
                        'answer' => 'It is the transport mechanism used with web services.',
                        'fraction' => '1',
                        'feedback' => 'Your answer is correct ',
                        'id' => 11687,
                    ),
                    11688 => (object) array(
                        'question' => '3863',
                        'answer' => 'It is a distributed object technology',
                        'fraction' => '0',
                        'feedback' => 'Your answer is incorrect. <br />The correct answer is b. ',
                        'id' => 11688,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '0',
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '49446',
            'attemptid' => '4338',
            'questionid' => '3863',
            'newest' => '112195',
            'newgraded' => '112195',
            'sumpenalty' => '0',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            112159 => (object) array(
                'attempt' => '4338',
                'question' => '3863',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '11686,11687,11688:',
                'timestamp' => '1179303963',
                'event' => '8',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 112159,
            ),
            112164 => (object) array(
                'attempt' => '4338',
                'question' => '3863',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '11686,11687,11688:',
                'timestamp' => '1179303963',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 112164,
            ),
            112176 => (object) array(
                'attempt' => '4338',
                'question' => '3863',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '11686,11687,11688:11687',
                'timestamp' => '1179303218',
                'event' => '2',
                'grade' => '0',
                'raw_grade' => '5',
                'penalty' => '0',
                'id' => 112176,
            ),
            112195 => (object) array(
                'attempt' => '4338',
                'question' => '3863',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '11686,11687,11688:11687',
                'timestamp' => '1179303218',
                'event' => '6',
                'grade' => '5',
                'raw_grade' => '5',
                'penalty' => '0',
                'id' => 112195,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 3863,
            'variant' => 1,
            'maxmark' => 5,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => 'What is SOAP?',
            'rightanswer' => 'It is the transport mechanism used with web services.',
            'responsesummary' => 'It is the transport mechanism used with web services.',
            'timemodified' => 1179303963,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1179303963,
                    'userid' => 30631,
                    'data' => array('_order' => '11686,11687,11688'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'complete',
                    'fraction' => null,
                    'timecreated' => 1179303218,
                    'userid' => 30631,
                    'data' => array('answer' => 1),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'gradedright',
                    'fraction' => 1,
                    'timecreated' => 1179303218,
                    'userid' => 30631,
                    'data' => array('answer' => 1, '-finish' => 1),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_qsession591() {
        $quiz = (object) array(
            'id' => '22',
            'course' => '272',
            'name' => 'ICT self-assessment quiz',
            'intro' => '<p>Work through the ICT skills self-assessment quiz in order to assess your ability to use ICT for study on the Youth Justice Programme. Doing this will also help you to plan a short programme of learning.</p>
        <p>Use the questions to rate your ability in each area as either:</p>
        <ul>
            <li>\'Well developed\'</li>
            <li>\'Not sure\', or</li>
            <li>\'Needs development\'.</li>
        </ul>
        <p>Once you have done that, and seen the feedback associated with your answers, you will need to think about prioritising the skills that need development. You will also need to allocate some time in order to develop the skills you need to concentrate on. Within the feedback for each question are some subject-related links which you may find useful.</p>',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'preferredbehaviour' => 'deferredfeedback',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '4',
            'decimalpoints' => '0',
            'review' => '71760879',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '0',
            'sumgrades' => '0',
            'grade' => '0',
            'timecreated' => '0',
            'timemodified' => '1174581121',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
        );
        $attempt = (object) array(
            'id' => '95',
            'uniqueid' => '94',
            'quiz' => '22',
            'userid' => '9721',
            'attempt' => '1',
            'timestart' => '1177777016',
            'timefinish' => '1177777128',
            'timemodified' => '1177777101',
            'layout' => '242,0,243,0,244,0,245,0,246,0,247,0',
            'preview' => '0',
            'sumgrades' => '0',
        );
        $question = (object) array(
            'id' => '247',
            'category' => '12',
            'parent' => '0',
            'name' => 'Regular access to a computer',
            'questiontext' => '[CUT]',
            'questiontextformat' => '1',
            'defaultmark' => '0',
            'penalty' => '0',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+070321164105+qIeJ9g',
            'hidden' => '0',
            'version' => 'learn.open.ac.uk+070427170153+plBFqV',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'timecreated' => '0',
            'timemodified' => '0',
            'createdby' => null,
            'modifiedby' => null,
            'unlimited' => null,
            'maxmark' => '0',
            'options' => (object) array(
                'id' => '180',
                'question' => '247',
                'layout' => '0',
                'answers' => array(
                    666 => (object) array(
                        'question' => '247',
                        'answer' => 'Well developed',
                        'feedback' => 'It\'s good that you don\'t feel as though you will have problems accessing a computer in order to study within the Youth Justice Programme. However, you may find the OU Library\'s information page on <a href="http://library.open.ac.uk/libraries/update/access_computers.html" target="blank"><b>Using public access computers in libraries and other venues</b></a> of interest.',
                        'fraction' => '1',
                        'id' => 666,
                    ),
                    667 => (object) array(
                        'question' => '247',
                        'answer' => 'Not sure',
                        'feedback' => 'We recommend that you visit the OU Library\'s information page on <a href="http://library.open.ac.uk/libraries/update/access_computers.html" target="blank"><b>Using public access computers in libraries and other venues</b></a>.',
                        'fraction' => '1',
                        'id' => 667,
                    ),
                    668 => (object) array(
                        'question' => '247',
                        'answer' => 'Needs development',
                        'feedback' => 'We recommend that you visit the OU Library\'s information page on <a href="http://library.open.ac.uk/libraries/update/access_computers.html" target="blank"><b>Using public access computers in libraries and other venues</b></a>.',
                        'fraction' => '1',
                        'id' => 668,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '0',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '591',
            'attemptid' => '94',
            'questionid' => '247',
            'newest' => '1220',
            'newgraded' => '1220',
            'sumpenalty' => '0',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            1208 => (object) array(
                'attempt' => '94',
                'question' => '247',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '666,667,668:',
                'timestamp' => '1177777016',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 1208,
            ),
            1219 => (object) array(
                'attempt' => '94',
                'question' => '247',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '666,667,668:666',
                'timestamp' => '1177777116',
                'event' => '2',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 1219,
            ),
            1220 => (object) array(
                'attempt' => '94',
                'question' => '247',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '666,667,668:666',
                'timestamp' => '1177777116',
                'event' => '6',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 1220,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 247,
            'variant' => 1,
            'maxmark' => 0,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => '[CUT]',
            'rightanswer' => 'Well developed',
            'responsesummary' => 'Well developed',
            'timemodified' => 1177777116,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1177777016,
                    'userid' => 9721,
                    'data' => array('_order' => '666,667,668'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'complete',
                    'fraction' => null,
                    'timecreated' => 1177777116,
                    'userid' => 9721,
                    'data' => array('answer' => 0),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'finished',
                    'fraction' => null,
                    'timecreated' => 1177777116,
                    'userid' => 9721,
                    'data' => array('answer' => 0, '-finish' => 1),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }

    public function test_multichoice_deferredfeedback_qsession594() {
        $quiz = (object) array(
            'id' => '22',
            'course' => '272',
            'name' => 'ICT self-assessment quiz',
            'intro' => '<p>Work through the ICT skills self-assessment quiz in order to assess your ability to use ICT for study on the Youth Justice Programme. Doing this will also help you to plan a short programme of learning.</p>
        <p>Use the questions to rate your ability in each area as either:</p>
        <ul>
            <li>\'Well developed\'</li>
            <li>\'Not sure\', or</li>
            <li>\'Needs development\'.</li>
        </ul>
        <p>Once you have done that, and seen the feedback associated with your answers, you will need to think about prioritising the skills that need development. You will also need to allocate some time in order to develop the skills you need to concentrate on. Within the feedback for each question are some subject-related links which you may find useful.</p>',
            'introformat' => FORMAT_HTML,
            'questiondecimalpoints' => '-1',
            'showuserpicture' => '1',
            'showblocks' => '1',
            'timeopen' => '0',
            'timeclose' => '0',
            'preferredbehaviour' => 'deferredfeedback',
            'attempts' => '0',
            'attemptonlast' => '0',
            'grademethod' => '4',
            'decimalpoints' => '0',
            'review' => '71760879',
            'questionsperpage' => '1',
            'shufflequestions' => '0',
            'shuffleanswers' => '0',
            'sumgrades' => '0',
            'grade' => '0',
            'timecreated' => '0',
            'timemodified' => '1174581121',
            'password' => '',
            'subnet' => '',
            'popup' => '0',
            'delay1' => '0',
            'delay2' => '0',
            'timelimit' => '0',
        );
        $attempt = (object) array(
            'id' => '95',
            'uniqueid' => '94',
            'quiz' => '22',
            'userid' => '9721',
            'attempt' => '1',
            'timestart' => '1177777016',
            'timefinish' => '1177777128',
            'timemodified' => '1177777101',
            'layout' => '242,0,243,0,244,0,245,0,246,0,247,0',
            'preview' => '0',
            'sumgrades' => '0',
        );
        $question = (object) array(
            'id' => '242',
            'category' => '12',
            'parent' => '0',
            'name' => 'Using the internet',
            'questiontext' => '<p><strong>Using the internet</strong></p>
        <p><font face="Verdana,Verdana" size="2">Many study resources are available online, and you will also be expected to find things out yourself using the web.</font></p>
        <p><i><font face="Verdana,Verdana" size="2">How would you rate your skills in using browsers and managing documents you find on the internet? </font></i></p>',
            'questiontextformat' => '1',
            'defaultmark' => '0',
            'penalty' => '0',
            'qtype' => 'multichoice',
            'length' => '1',
            'stamp' => 'learn.open.ac.uk+070321161800+WlAJ5D',
            'hidden' => '0',
            'version' => 'learn.open.ac.uk+070329133200+dO4WQO',
            'generalfeedback' => '',
            'generalfeedbackformat' => '1',
            'timecreated' => '0',
            'timemodified' => '0',
            'createdby' => null,
            'modifiedby' => null,
            'unlimited' => null,
            'maxmark' => '0',
            'options' => (object) array(
                'id' => '175',
                'question' => '242',
                'layout' => '0',
                'answers' => array(
                    651 => (object) array(
                        'question' => '242',
                        'answer' => 'Well developed',
                        'feedback' => 'You obviously feel confident about using the internet in order to manage your documentation and find information on the World Wide Web. However, you may still find the OU\'s <a href="http://www.open.ac.uk/webguide/" target="blank"><b>Web Guide</b></a> site of interest.',
                        'fraction' => '1',
                        'id' => 651,
                    ),
                    652 => (object) array(
                        'question' => '242',
                        'answer' => 'Not sure',
                        'feedback' => 'We recommend that you visit the OU\'s <a href="http://www.open.ac.uk/webguide/" target="blank"><b>Web Guide</b></a> site and work through some of the tips and advice about using the web effectively.',
                        'fraction' => '1',
                        'id' => 652,
                    ),
                    653 => (object) array(
                        'question' => '242',
                        'answer' => 'Needs development',
                        'feedback' => 'We recommend that you visit the OU\'s <a href="http://www.open.ac.uk/webguide/" target="blank"><b>Web Guide</b></a> site and work through some of the tips and advice about using the web effectively.',
                        'fraction' => '1',
                        'id' => 653,
                    ),
                ),
                'single' => '1',
                'shuffleanswers' => '0',
                'answernumbering' => 'abc',
                'showstandardinstruction' => 0,
                'correctfeedback' => '',
                'partiallycorrectfeedback' => '',
                'incorrectfeedback' => '',
            ),
            'hints' => false,
        );
        $qsession = (object) array(
            'id' => '594',
            'attemptid' => '94',
            'questionid' => '242',
            'newest' => '1223',
            'newgraded' => '1223',
            'sumpenalty' => '0',
            'manualcomment' => '',
            'manualcommentformat' => '1',
            'flagged' => '1',
        );
        $qstates = array(
            1211 => (object) array(
                'attempt' => '94',
                'question' => '242',
                'originalquestion' => '0',
                'seq_number' => '0',
                'answer' => '651,652,653:',
                'timestamp' => '1177777016',
                'event' => '0',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 1211,
            ),
            1214 => (object) array(
                'attempt' => '94',
                'question' => '242',
                'originalquestion' => '0',
                'seq_number' => '1',
                'answer' => '651,652,653:651',
                'timestamp' => '1177777040',
                'event' => '2',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 1214,
            ),
            1223 => (object) array(
                'attempt' => '94',
                'question' => '242',
                'originalquestion' => '0',
                'seq_number' => '2',
                'answer' => '651,652,653:651',
                'timestamp' => '1177777040',
                'event' => '6',
                'grade' => '0',
                'raw_grade' => '0',
                'penalty' => '0',
                'id' => 1223,
            ),
        );

        $qa = $this->updater->convert_question_attempt($quiz, $attempt, $question, $qsession, $qstates);

        $expectedqa = (object) array(
            'behaviour' => 'deferredfeedback',
            'questionid' => 242,
            'variant' => 1,
            'maxmark' => 0,
            'minfraction' => 0,
            'maxfraction' => 1,
            'flagged' => 0,
            'questionsummary' => "USING THE INTERNET \n\nMany study resources are available online, and you will also be expected to find things out yourself using the web. \n\n_How would you rate your skills in using browsers and managing documents you find on the internet? _",
            'rightanswer' => 'Well developed',
            'responsesummary' => 'Well developed',
            'timemodified' => 1177777040,
            'steps' => array(
                0 => (object) array(
                    'sequencenumber' => 0,
                    'state' => 'todo',
                    'fraction' => null,
                    'timecreated' => 1177777016,
                    'userid' => 9721,
                    'data' => array('_order' => '651,652,653'),
                ),
                1 => (object) array(
                    'sequencenumber' => 1,
                    'state' => 'complete',
                    'fraction' => null,
                    'timecreated' => 1177777040,
                    'userid' => 9721,
                    'data' => array('answer' => '0'),
                ),
                2 => (object) array(
                    'sequencenumber' => 2,
                    'state' => 'finished',
                    'fraction' => null,
                    'timecreated' => 1177777040,
                    'userid' => 9721,
                    'data' => array('answer' => '0', '-finish' => 1),
                ),
            ),
        );

        $this->compare_qas($expectedqa, $qa);
    }
}
